require( "quest/m1_petshop/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:Face(DIR.E);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		if game:Get("first_time_pet_shop") < 1 then
			actor:JumpToNamedPoint("to_spendalot");
			actor:WalkTo("flo");
			wait_walkto();
			actor:FaceNow(DIR.SE);
			coroutine.yield(RESUME.ON_CLICK);
			scene.CASSIE:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			scene.CASSIE:PlayAnim("DoStandW");
			run_super_conversation(actor, "conv_pet_shop_intro");
			game:Set("first_time_pet_shop", 1);
		elseif game:GetLastScene() == "mg_package" then
			actor:JumpToNamedPoint("flo");
			actor:FaceNow(DIR.SE);
			if game:Get("mg_package_activity_round") > 1 and
			game:Get("got_dog_treat") < 1 then
				run_super_conversation(actor, "quip_petshop_done");
				complete_quest("need_dog_treats", false);
				complete_quest("got_dog_treats");
			else
				run_super_conversation(actor, "quip_petshop_not_done");
			end
			actor:SetMode(MODE.FOLLOWCLICKS);
		else
			actor:JumpToNamedPoint("to_spendalot");
			actor:WalkTo("flo");
			wait_walkto();
			actor:FaceNow(DIR.SE);
		end
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		if BAG_INV:CheckInventory("dogtreat") == true then
			convproc("FLO", "quip_petshop_C");
		elseif game:Get("mg_package_activity_round") == 1 then
			convproc("FLO", "quip_petshop_B");
		elseif game:Get("clicked_on_dogtreats") < 1 then
			convproc("FLO", "quip_petshop_A");
		else
			convproc("FLO", "quip_petshop_D");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function cassie_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("talked_to_cassie") < 1 and game:Get("mg_package_activity_round") < 1 then
		run_super_conversation(flo, "conv_cassie_A");
		game:Set("talked_to_cassie", 1);
	elseif game:Get("mg_package_activity_round") > 0 and
		game:Get("got_dog_treat") < 1 then
		run_super_conversation(flo, "conv_cassie_not_done");
	elseif game:Get("got_dog_treat") > 0 and 
		game:Get("got_snookums") < 1 then
		run_super_conversation(flo, "conv_cassie_done");
	else
		run_super_conversation(flo, "quip_petshop_D");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cassie_spec = 
{
	name = "CASSIE";
	halo = "quest/objects/cassiew";
	
	command = function(actor)
		prepare_actor_text(actor, cassie_text_spec);
		actor:ModifySaySpec{ bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_FORCEVFLIP };
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cassie_speed);
		actor:FaceNow(DIR.W);
		
		if game:Get("mg_package_activity_round") < 1 then
			actor:JumpToNamedPoint("cassie_box");
			actor:LoadAnimFile("anim/cassie/box");
			actor:LoadAnimFile("anim/cassie/box_talk");
			
			if game:Get("first_time_pet_shop") < 1 then
				actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
				actor:PlayAnim("Boxing");
			else
				actor:PlayAnim("DoStandW");
			end
		else
			actor:JumpToNamedPoint("cassie");
			actor:LoadAnimFile("anim/cassie/stand");
			actor:PlayAnim("DoStandW");
			actor:ModifySaySpec { mouth_in_actor = { x = cassie_text_spec.mouth_in_actor.x, y = cassie_text_spec.mouth_in_actor.y + 30 } };
		end
	end;
	
	on_arrive=  function(flo, cassie)
		flo:StartProc(cassie_conv);
	end;
};

function gotospendalot(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("to_spendalot");
	wait_walkto();
	goto_scene(flo, "m1_spendalot1");
end

to_spendalot_spec = 
{
	name = "TO_SPENDALOT";
	halo = "to_spendalot";
	cursor = "cursor_arrow_w";
	goto_fn = gotospendalot;
}

fish_spec = 
{
	name = "FISH";
	gfx = { anim = "anim/m1_petshop/fish" };
	halo = "fish";
	
	command = function(actor)
		actor:PlayAnim("fish");
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				run_super_conversation(flo, "quip_fish");
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		)
	end;
}

function lookat_treats(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("got_dog_treat") < 1 then
		if game:Get("mg_package_activity_round") < 1 then
			run_super_conversation(flo, "conv_dog_treats");
			if not quest_added("need_dog_treats") then
				add_quest("need_dog_treats", false);
			end

			goto_scene(flo, "mg_package");
		else
			run_super_conversation(flo, "conv_dog_treats_not_done");
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	else
		run_super_conversation(flo, "conv_dog_treats_done");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end;

gourmet_treats_sign_spec = 
{
	name = "FLOS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/jokerman.mvec",
			color = { a = 1, r = 0.57, g = 0.97, b = 0.67 },
			--outline_size = 1,
			linepadding = -12,
			lineheight = 40,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_gourmet_treats_sign");
		actor:StopWalking();
		actor:SetPolygon({x=8,y=157}, {x=110,y=129}, {x=8,y=231}, {x=109,y=202});
		actor:TextToImage(0, 0);
	end;
}


treats_spec = 
{
	name = "TREATS";
	halo = "treats";
	gfx = { image = "treats" };
	
	command = function(actor)
		actor:SetDepthValue(345);
	end;
	
	on_arrive = function(flo, to_spendalot)
		game:Set("clicked_on_dogtreats", 1);
		flo:StartProc(lookat_treats);
	end;
}

function lookat_boxes(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("clicked_on_dogtreats") < 1 or game:Get("got_dog_treat") > 0 then
		run_super_conversation(flo, "quip_boxes");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		run_super_conversation(flo, "quip_try_again");
		goto_scene(flo, "mg_package");
	end
end

function boxes_on_arrive(flo, boxes)
	flo:StartProc(lookat_boxes);
end;

box1_spec = 
{
	name = "BOX1";
	halo = "boxes";
	
	command = function(actor)
		actor:SetDepthValue(400);
		
		if game:Get("mg_package_activity_round") > 1 then
			actor:LoadImage("PetShop_box1_wrap");
		else
			actor:LoadImage("PetShop_box1_open");
		end
	end;
	
	on_arrive = boxes_on_arrive;
}

box2_spec = 
{
	name = "BOX2";
	halo = "boxes";
	
	command = function(actor)
		actor:SetDepthValue(400);
		
		if game:Get("mg_package_activity_round") > 1 then
			actor:LoadImage("PetShop_box2_wrap");
		else
			actor:LoadImage("PetShop_box2_open");
		end
	end;
	
	on_arrive = boxes_on_arrive;
}

box3_spec = 
{
	name = "BOX3";
	halo = "boxes";
	
	command = function(actor)
		actor:SetDepthValue(400);
		
		if game:Get("mg_package_activity_round") > 1 then
			actor:LoadImage("PetShop_box3_wrap");
		else
			actor:LoadImage("PetShop_box3_open");
		end
	end;
	
	on_arrive = boxes_on_arrive;
}

bird_spec = 
{
	name = "BIRD";
	halo = "bird";
	gfx = { anim = "anim/m1_petshop/bird" };
	
	command = function(actor)
		prepare_actor_text(actor);
		actor:ModifySaySpec { mouth_in_actor = { x = 450, y = 50 } };
		actor:SetDepthValue(279);
		--actor:ModifySaySpec{ x= 300, y = 10 };
		actor:FaceNow(DIR.E);
	end;
	
	on_arrive = function(flo, bird)
		if game:Get("talked_to_bird_in_petshop") < 1 then
			game:Set("talked_to_bird_in_petshop", 1);
			convproc("FLO", "quip_bird_A");
		elseif game:Get("talked_to_bird_in_petshop") < 2 then
			convproc("FLO", "quip_bird_B");
			game:Set("talked_to_bird_in_petshop", 2);
		elseif game:Get("talked_to_bird_in_petshop") < 3 then
			convproc("FLO", "quip_bird_C");
			game:Set("talked_to_bird_in_petshop", 3);
		else
			local rand = math.random(1, 3);
			local quips = 
			{
				"quip_bird_A",
				"quip_bird_B",
				"quip_bird_C"
			};
			convproc("FLO", quips[rand]);
		end
	end;
}

puppy_spec = 
{
	name = "DOG";
	halo = "puppy";
	gfx = { anim = "anim/m1_petshop/dog" };
	
	command = function(actor)
		actor:FaceNow(DIR.E);
		prepare_actor_text(actor);
		actor:SetDepthValue(314);
		actor:ModifySaySpec
		{
			mouth_in_actor = { x = 730, y = 250 },
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_AUTOVFLIP,
		};
		bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_AUTOVFLIP
		--actor:ModifySaySpec{ x= 550, y = 100 };
	end;
	
	on_arrive = function(flo, puppy)
		if game:Get("talked_to_puppy_in_petshop") < 1 then
			game:Set("talked_to_puppy_in_petshop", 1);
			convproc("FLO", "quip_puppy_A");
		else
			convproc("FLO", "quip_puppy_B");
		end
		puppy:PlayAnim("dog");
	end;
}

doghouse_spec = 
{
	name = "DOGHOUSE";
	halo = "doghouse";
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, doghouse)
		convproc("FLO", "quip_doghouse");
	end;
}

collars_spec = 
{
	name = "COLLARS";
	halo = "collars";
	
	command = function(actor)
		actor:SetDepthValue(300);
	end;
	
	on_arrive = function(flo, doghouse)
		convproc("FLO", "quip_collars");
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petshopmusic.ogg", true);
		scene:SetRoomScale(250, 300, 0.9, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end
		
		spawn_nav_arrow(to_spendalot_spec);
		
		game:SetString("map_position", "m1_petshop");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "dog_cage_back", 250 },
		{ "bird_cage_back", 270 },
		{ "bird_cage_front", 280 },
		{ "dog_cage_front", 315 },
		{ "kennel", 550 },
		
		{"sink", DEPTH.DEPTH_FRONTMOST},
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		cassie_spec,
		treats_spec,
		box1_spec,
		box2_spec,
		box3_spec,
		bird_spec,
		puppy_spec,
		doghouse_spec,
		gourmet_treats_sign_spec,
		collars_spec,
		fish_spec,
		flo_spec, -- the main actor
		
		scene_setup,
	};
};
